import os
import sys
import cv2
import json
import numpy as np


class TrajectoryLogger:
    def __init__(self,
                 logdir='results/cooperative_perception_overtake/eval/test/',
                 frequency=10,
                 ):
        self.logdir = get_next_episode_folder(logdir)
        if not os.path.exists(self.logdir):
            os.makedirs(self.logdir, exist_ok=True)
        self.frequency = frequency

    def log(self,
            frame_id, agent_id, info={},
            ):
        if frame_id % self.frequency != 0: return
        if not os.path.exists(self.logdir+f'{agent_id}/'):
            os.makedirs(self.logdir+f'{agent_id}/', exist_ok=True)
        filename = self.logdir + f'{agent_id}/frame_{frame_id}.json'
        if os.path.exists(filename):
            prev_data = json.load(open(filename, 'r'))
            prev_data.update(info)
            info = prev_data
        json.dump(info, open(filename, 'w'))
    
    def get_logdir(self):
        return self.logdir

def get_next_episode_folder(logdir):
    episode = 0
    while os.path.exists(logdir+f'episode_{episode}'):
        episode += 1
    return logdir + f'episode_{episode}/'

if __name__ == '__main__':
    TrajectoryLogger()
